﻿//////////////////////////////////////////////
// LogManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkLog
{
	class Logger ;
}

/// Includes ---------------------------------

// nkMemory
#include "../Dll/DllDefines.h"

#include "../Containers/StringView.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

/// Class ------------------------------------

namespace nkMemory
{	
	class DLL_MEMORY_EXPORT LogManager final : public nkCommon::SingletonClass<LogManager>
	{
		public :

			// Getters
			nkLog::Logger* getReceiver () const ;

			// Setters
			void setReceiver (nkLog::Logger* receiver) ;

			// Log
			void log (StringView message, StringView className) ;

		private :

			// Constructeur, destructeur
			LogManager () noexcept ;
			LogManager (const LogManager&) = delete ;
			LogManager (LogManager&&) = delete ;

			// Operators
			LogManager& operator= (const LogManager&) = delete ;
			LogManager& operator= (LogManager&&) = delete ;

		private :

			// Le logger enregistré
			nkLog::Logger* _receiver ;

		private :

			friend class nkCommon::SingletonClass<LogManager> ;
	} ;
}